/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class GTable extends JTable {

    private static SimpleDateFormat aSimpleDateFormat = null;

    /**
     * 
     */
    public GTable() {
        super();
        initialize();
    }

    /**
     * @param inpNumRows
     * @param inpNumColumns
     */
    public GTable(int inpNumRows, int inpNumColumns) {
        super(inpNumRows, inpNumColumns);
        initialize();
    }

    /**
     * @param inpRowData
     * @param inpColumnNames
     */
    public GTable(Object[][] inpRowData, Object[] inpColumnNames) {
        super(inpRowData, inpColumnNames);
        initialize();
    }

    /**
     * @param inpDm
     * @param inpCm
     * @param inpSm
     */
    public GTable(TableModel inpDm, TableColumnModel inpCm,
            ListSelectionModel inpSm) {
        super(inpDm, inpCm, inpSm);
        initialize();
    }

    /**
     * @param inpDm
     * @param inpCm
     */
    public GTable(TableModel inpDm, TableColumnModel inpCm) {
        super(inpDm, inpCm);
        initialize();
    }

    /**
     * @param inpDm
     */
    public GTable(TableModel inpDm) {
        super(inpDm);
        initialize();
    }

    /**
     * @param inpRowData
     * @param inpColumnNames
     */
    public GTable(Vector inpRowData, Vector inpColumnNames) {
        super(inpRowData, inpColumnNames);
        initialize();
    }

    private void initialize() {
        setShowGrid(false);
        setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

    }

    protected String shortPathOf(String inpPath) {
        if (inpPath == null) {
            return "";
        }
        char tmpC = File.separatorChar;
        int x1 = inpPath.indexOf(tmpC);
        String tmpString = "";
        if (x1 > 0) {
            int len = inpPath.length();
            tmpString += inpPath.substring(0, x1 + 1);
            inpPath = (len - 1 == x1) ? "" : inpPath.substring(x1 + 1);
        }
        int x2 = inpPath.lastIndexOf(File.separatorChar);
        tmpString += (x2 == x1 || x2 < 0) ? inpPath : "..."
                + inpPath.substring(x2);
        return tmpString;
    }

    public String getToolTipText(MouseEvent inpEvent) {
        try {
            Point tmpPoint = inpEvent.getPoint();
            int row = rowAtPoint(tmpPoint);
            TableModel tmpModel = getModel();
            Object tmpObject = null;
            if (tmpModel instanceof GTableModel) {
                tmpObject = ((GTableModel) tmpModel).getObjectAtRow(row);
            } else {
                tmpObject = getGTableModel().getObjectAtRow(row);
            }
            if (tmpObject instanceof XInputFile) {
                XInputFile tmpFile = (XInputFile) tmpObject;
                StringBuffer tmpBuf = new StringBuffer();
                tmpBuf.append("<html><b>");
                tmpBuf.append(tmpFile.getName());
                tmpBuf.append("</b><br>");
                long tmpL = tmpFile.lastModified();
                Date tmpDate = new Date(tmpL);
                String tmpStr = getSimpleDateFormat().format(tmpDate);
                tmpBuf.append(tmpStr);
                tmpBuf.append("<br>");
                tmpBuf.append(tmpFile.getParent());
                tmpBuf.append("</html>");
                return tmpBuf.toString();
            } 
            if (tmpObject instanceof File) {
                File tmpFile = (File) tmpObject;
                StringBuffer tmpBuf = new StringBuffer();
                tmpBuf.append("<html><b>");
                tmpBuf.append(tmpFile.getName());
                tmpBuf.append("</b><br>");
                long tmpL = tmpFile.lastModified();
                Date tmpDate = new Date(tmpL);
                String tmpStr = getSimpleDateFormat().format(tmpDate);
                tmpBuf.append(tmpStr);
                tmpBuf.append("<br>");
                tmpBuf.append(tmpFile.getParent());
                tmpBuf.append("</html>");
                return tmpBuf.toString();
            } 
            GAufnahmeIF tmpAufnahme = null;
            if (tmpObject instanceof GAufnahmeIF) {
                tmpAufnahme = (GAufnahmeIF) tmpObject;
            }
            if (tmpObject instanceof GAufnahmeContainer) {
                GAufnahmeContainer tmpContainer = (GAufnahmeContainer) tmpObject;
                tmpAufnahme = tmpContainer.getAufnahme();
            }
            if (tmpAufnahme != null) {
                StringBuffer tmpBuf = new StringBuffer();
                tmpBuf.append("<html>");
                String tmpStr = tmpAufnahme.getSender();
                if (tmpStr != null && tmpStr.length() > 0) {
                    tmpBuf.append(tmpAufnahme.getSender());
                    tmpBuf.append("<br>");
                }
                tmpBuf.append("<b>");
                tmpBuf.append(tmpAufnahme.getTitel());
                tmpBuf.append("</b><br>");
                tmpBuf.append(shortPathOf(tmpAufnahme.getCridFilename()));
                String[] tmpStrings = tmpAufnahme.getDateinamenBasen();
                int anz = (tmpStrings == null) ? 0 : tmpStrings.length;
                for (int i = 0; i < anz; i++) {
                    tmpBuf.append("<br>");
                    tmpBuf.append(tmpStrings[i]);
                } // for i
                tmpBuf.append("</html>");
                return tmpBuf.toString();
            }
            if (tmpObject != null) {
                return tmpObject.toString();
            }
        } catch (RuntimeException exc) {
            // ignore !! exc.printStackTrace();
        }
        return super.getToolTipText(inpEvent);
    }

    /**
     * @return simpleDateFormat
     */
    protected SimpleDateFormat getSimpleDateFormat() {
        if (aSimpleDateFormat == null) {
            aSimpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        }
        return aSimpleDateFormat;
    }

    /* (Kein Javadoc)
     * @see javax.swing.JTable#getModel()
     */
    public GTableModel getGTableModel() {
        TableModel tmpModel = super.getModel();
        if (tmpModel instanceof GTableModel) {
            return (GTableModel)tmpModel;
        }
        return null;
    }

}
